/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis.providers;

import java.util.Collections;
import java.util.Map;
import net.impactdev.impactor.relocations.org.apache.commons.pool2.PooledObjectFactory;
import net.impactdev.impactor.relocations.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.Connection;
import net.impactdev.impactor.relocations.redis.clients.jedis.ConnectionFactory;
import net.impactdev.impactor.relocations.redis.clients.jedis.ConnectionPool;
import net.impactdev.impactor.relocations.redis.clients.jedis.HostAndPort;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.providers.ConnectionProvider;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.Pool;

public class PooledConnectionProvider
implements ConnectionProvider {
    private final Pool<Connection> pool;
    private Object connectionMapKey = "";

    public PooledConnectionProvider(HostAndPort hostAndPort) {
        this(new ConnectionFactory(hostAndPort));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new ConnectionPool(hostAndPort, clientConfig));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig), poolConfig);
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory2) {
        this(new ConnectionPool(factory2));
        this.connectionMapKey = factory2;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory2, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionPool(factory2, poolConfig));
        this.connectionMapKey = factory2;
    }

    private PooledConnectionProvider(Pool<Connection> pool) {
        this.pool = pool;
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public final Pool<Connection> getPool() {
        return this.pool;
    }

    @Override
    public Connection getConnection() {
        return this.pool.getResource();
    }

    @Override
    public Connection getConnection(CommandArguments args2) {
        return this.pool.getResource();
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        return Collections.singletonMap(this.connectionMapKey, this.pool);
    }
}

